﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Excel = Microsoft.Office.Interop.Excel;

namespace Kalendarz
{
    public partial class Kalendarz : UserControl
    {
        List<Zadanie> listaZadan = new List<Zadanie>();
        public static SzczegolyZadania szczegolyZadania;

        public Kalendarz()
        {
            InitializeComponent();
            szczegolyZadania = new SzczegolyZadania(this);
            szczegolyZadania.Visible = false;
        }

        public struct Zadanie
        {
            public Int64 IdZadania;
            public DateTime dataRozpoczecia;
            public DateTime dataZakonczenia;
            public string opis;
        }

        public void DodajZadanie(Zadanie zadanie)
        {
            if (listaZadan.Count > 0)
            {
                Int64 idOstatniegoZadania = listaZadan.Last<Zadanie>().IdZadania;
                ++zadanie.IdZadania;
            }
            else
                zadanie.IdZadania = 0;

            listaZadan.Add(zadanie);
            if (monthCalendar1.BoldedDates.Length == 0)
                monthCalendar1.BoldedDates = new DateTime[]{zadanie.dataRozpoczecia};
            else
            {
                List<DateTime> daty = monthCalendar1.BoldedDates.ToList<DateTime>();
                daty.Add(zadanie.dataRozpoczecia);
                monthCalendar1.BoldedDates = daty.ToArray();
            }
                
        }

        //public void UsunZadanie(Zadanie zadanie)
        //{
        //    var zadanieDoUsuniecia = from z in listaZadan
        //                             where z.IdZadania == zadanie.IdZadania
        //                             select z;

        //    listaZadan.Remove(zadanieDoUsuniecia.First<Zadanie>());
        //}

        private void przygotujArkusz(Excel.Worksheet ws)
        {
            int liczbaKolumn = 3;

            // Usunięcie zawartości
            for (int i = 1; i <= liczbaKolumn; i++)
            {
                ws.Columns[i].Clear();
            }

            // Ustalenie szerokości kolumn
            ws.Range["A:A"].ColumnWidth = 20;
            ws.Range["B:B"].ColumnWidth = 20;
            ws.Range["C:C"].ColumnWidth = 60;

            // Wyrównanie zawartości komórek
            ws.Range["A:A"].HorizontalAlignment = Excel.XlHAlign.xlHAlignCenter;
            ws.Range["B:B"].HorizontalAlignment = Excel.XlHAlign.xlHAlignCenter;
            ws.Range["C:C"].HorizontalAlignment = Excel.XlHAlign.xlHAlignJustify;

            // Wytłuszczenie czcionki
            ws.Rows[1].Font.Bold = true;

            // Utworzenie nagłówka
            ws.Cells[1, 1].Value2 = "Data rozpoczęcia";
            ws.Cells[1, 2].Value2 = "Data zakończenia";
            ws.Cells[1, 3].Value2 = "Opis zadania";

            // Zmiana koloru nagłówka
            ws.Range["A1", "C1"].Interior.Color = Excel.XlRgbColor.rgbYellow;

            // Formatowanie dat
            ws.Columns[1].NumberFormat = "DD/MM";
            ws.Columns[2].NumberFormat = "DD/MM";

            // Zawijanie tekstu w kolumnie opis
            ws.Columns[3].WrapText = true;
        }

private void button1_Click(object sender, EventArgs e)
{
    szczegolyZadania.wyczysc();
    szczegolyZadania.ustawDate(monthCalendar1.SelectionStart);
    szczegolyZadania.ShowDialog();
}

private void button2_Click(object sender, EventArgs e)
{
    Excel.Application xlApp = (Excel.Application)Globals.ThisAddIn.Application;

    string komunikatObledzie = "Brak zadań w wybranym terminie";

    przygotujArkusz(xlApp.ActiveSheet);

    if (listaZadan.Count == 0)
    {
        xlApp.ActiveSheet.Range["A2"].Value2 = komunikatObledzie;
        return;
    }

    var zadania = from z in listaZadan
                    where z.dataRozpoczecia == monthCalendar1.SelectionStart
                    select z;

    if (zadania == null)
    {
        xlApp.ActiveSheet.Range["A2"].Value2 = komunikatObledzie;
        return;
    }
    else
    {
        int indeksWiersza = 2;

        foreach (Zadanie z in zadania)
        {
            xlApp.ActiveSheet.Cells[indeksWiersza, 1].Value2 = z.dataRozpoczecia;
            xlApp.ActiveSheet.Cells[indeksWiersza, 2].Value2 = z.dataZakonczenia;
            xlApp.ActiveSheet.Cells[indeksWiersza, 3].Value2 = z.opis;

            // Automatyczne dopasowanie wysokości wiersza do zawartości komórek
            xlApp.ActiveSheet.Rows[indeksWiersza].AutoFit();

            indeksWiersza++;
        }
    }
}
    }
}
